#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_TestResult : BaseTest 
	{

		private DataTable _dtTestResult;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
			
			if (this.RefreshData)
			{
				//Get TestResult**************************************************************
				this._dtTestResult = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM TestResult", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetTestResults_Pass()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			DataTable dtTest = DAL.TestResult.GetTestResults(unitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTest.LabTestId), TABLES.PatientTest.LabTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTest.PatientTestGuid), TABLES.PatientTest.PatientTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTest.OrderableTestId), TABLES.PatientTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTest.ResultDateTime), TABLES.PatientTest.ResultDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTest.TestResult), TABLES.PatientTest.TestResult);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.VistaLaboratoryTestName), TABLES.SpecimenTestThreshold.VistaLaboratoryTestName);
		}

		[Test]
		public void GetTestResults_Fail()
		{
			DataTable dtTest = DAL.TestResult.GetTestResults(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTestResult_Pass()
		{
			string testResultId = this._dtTestResult.Rows[0][TABLES.TestResult.TestResultId].ToString();

			DataTable dtTest = DAL.TestResult.GetTestResult(testResultId);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultId), TABLES.TestResult.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.CanChangeIndicator), TABLES.TestResult.CanChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.SortColumn), TABLES.TestResult.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.LastUpdateDate), TABLES.TestResult.LastUpdateDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.LastUpdateUser), TABLES.TestResult.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.RowVersion), TABLES.TestResult.RowVersion);
		}

		[Test]
		public void GetTestResult_Fail()
		{
			DataTable dtTest = DAL.TestResult.GetTestResult("-1");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}
#endif
